//-----------------------------------------------------------------------------
// File: client_game.cs
// This file contains game specific functions (enter and exit game) as well as
// some server command callback functions for heroes and modes
// Copyright Sandlot Games, 2007
// Author: Matthew Rudge
//-----------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////
// Called when the client's game officially begins
///////////////////////////////////////////////////////////////////////////////
function clientBeginGame()
{
   slgBuildObjectSystem();
   slgBuildObjectDatabase();
   slgLoadUIStrings();
   
   $SLItemBase::LockedImage = "assets/client/ui/icons/lock.png";
   $SLItemBase::LockedOffset = "0 -4";
   InitializeLockedIcon();
   InitializeResourceInfo();
   applyBuildingDataToBuildingButton();
   slgBuildProfiles();
}

///////////////////////////////////////////////////////////////////////////////
//! Called when the client's game officially ends (by entering the main menu
//! or by closing the game prematurely)
//! \param %closing True if the game is exiting to desktop
///////////////////////////////////////////////////////////////////////////////
function clientEndGame(%exiting)
{
   // Clear resources
   ClearResourceInfo();
   
   // Bring down alert system
   alertDestroySystem();
   
   // Clear production boosts
   clearProductionBoosts();
   
   // Clear the disabled commands
   csClearDisabledCommands();
   
   // Remove all ambient sounds
   popAllAmbientSound();
   
   if(%exiting) {
      clientCmdDestroyInventory();
   }
}

//-Commands from server---------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Called when the game mode changes on the server
//! \param %iMode New mode for game. One of the $WW2MODE_* defines
////////////////////////////////////////////////////////////////////////////////
function clientCmdGameModeChanged(%iMode)
{
   //echo(%iMode);
}

////////////////////////////////////////////////////////////////////////////////
//! Called when the hero changes on the server
//! \param %iHero New hero for game.  One of the $WW2HERO_* defines
////////////////////////////////////////////////////////////////////////////////
function clientCmdHeroChanged(%iHero)
{
   //echo(%iHero);
   // Set hero image on mini-map
   LocateHeroButton.stateUp    = $HeroImage[%iHero];
   LocateHeroButton.stateDown  = $HeroImage[%iHero];
   LocateHeroButton.stateFocus = $HeroFocusImage[%iHero];
}

////////////////////////////////////////////////////////////////////////////////
//! Called when the object needs to be deselected.
//! \param %obj The ghost object id to be deselected.
////////////////////////////////////////////////////////////////////////////////
function clientCmdRemoveFromSelection(%obj)
{
   %id = slgResolveGhost(%obj);
   if (isObject(%id) == false)
   {
      return;
   }
   
   %foundObject = removeFromSelection(%id);

   // if a building still needs to be placed but is being placed by the
   // removed object, then cancel the building placement
   if (%foundObject == true && PlayGui.hasObject() == true)
   {
      CancelBuilding();
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Called when an object needs to be selected.
//! \param %obj The ghost object id to be selected.
////////////////////////////////////////////////////////////////////////////////
function clientCmdSelectObject(%obj)
{
   selectObject(ServerConnection.resolveGhostID(%obj));
}

////////////////////////////////////////////////////////////////////////////////
//! Called when a tech change occurs on the server
//! \param %techType Type of tech (used to get button name for tech)
//! \param %bReqMet True if the requirment is met
////////////////////////////////////////////////////////////////////////////////
function clientCmdOnTechChange(%techType, %bReqMet)
{
   %btnName = %techType @ "Button";
   
   // This is a special case...button is still disabled if bridge is in the 
   // process of being built
   if(%btnName $= "BridgeButton") {
      if(slgIsBeingConstructed("Bridge")) {
         if(!%btnName.Disabled) {
            %btnName.Disabled = true;
         }
         return;
      }
   }
   
   // Default for all
   %btnName.Disabled = !%bReqMet;
}
//------------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Old Torque Functions
// Game start / end events sent from the server
//----------------------------------------------------------------------------
function clientCmdGameStart(%seq)
{
}

function clientCmdGameEnd(%seq)
{
}

// End game.cs